/******************************************************************************
 * Copyright 2013-2014 Espressif Systems (Wuxi)
 *
 * FileName: user_main.c
 *
 * Description: entry file of user application
 *
 * Modification history:
 *     2015/1/23, v1.0 create this file.
*******************************************************************************/

#include "osapi.h"
#include "at_custom.h"
#include "user_interface.h"
#include "gpio.h"

LOCAL os_timer_t link_led_timer;
LOCAL uint32 link_start_time;
LOCAL uint8 link_led_level = 0;


//// test :AT+TEST=1,"abc"<,3>
//void ICACHE_FLASH_ATTR
//at_setupCmdTest(uint8_t id, char *pPara)
//{
//    int result = 0, err = 0, flag = 0;
//    uint8 buffer[32] = {0};
//    pPara++; // skip '='
//
//    //get the first parameter
//    // digit
//    flag = at_get_next_int_dec(&pPara, &result, &err);
//
//    // flag must be ture because there are more parameter
//    if (flag == FALSE) {
//        at_response_error();
//        return;
//    }
//
//    if (*pPara++ != ',') { // skip ','
//        at_response_error();
//        return;
//    }
//
//    os_sprintf(buffer, "the first parameter:%d\r\n", result);
//    at_port_print(buffer);
//
//    //get the second parameter
//    // string
//    at_data_str_copy(buffer, &pPara, 10);
//    at_port_print("the second parameter:");
//    at_port_print(buffer);
//    at_port_print("\r\n");
//
//    if (*pPara == ',') {
//        pPara++; // skip ','
//        result = 0;
//        //there is the third parameter
//        // digit
//        flag = at_get_next_int_dec(&pPara, &result, &err);
//        // we donot care of flag
//        os_sprintf(buffer, "the third parameter:%d\r\n", result);
//        at_port_print(buffer);
//    }
//
//    if (*pPara != '\r') {
//        at_response_error();
//        return;
//    }
//
//    at_response_ok();
//}
//
//void ICACHE_FLASH_ATTR
//at_testCmdTest(uint8_t id)
//{
//    uint8 buffer[32] = {0};
//
//    os_sprintf(buffer, "%s\r\n", "at_testCmdTest");
//    at_port_print(buffer);
//    at_response_ok();
//}
//
//void ICACHE_FLASH_ATTR
//at_queryCmdTest(uint8_t id)
//{
//    uint8 buffer[32] = {0};
//
//    os_sprintf(buffer, "%s\r\n", "at_queryCmdTest");
//    at_port_print(buffer);
//    at_response_ok();
//}
//
//void ICACHE_FLASH_ATTR
//at_exeCmdTest(uint8_t id)
//{
//    uint8 buffer[32] = {0};
//
//    os_sprintf(buffer, "%s\r\n", "at_exeCmdTest");
//    at_port_print(buffer);
//    at_response_ok();
//}

void ICACHE_FLASH_ATTR
at_exeCmdLedOn(uint8_t id)
{
    GPIO_OUTPUT_SET(GPIO_ID_PIN(12), 0);
    at_response_ok();
}
void ICACHE_FLASH_ATTR
at_exeCmdLedOff(uint8_t id)
{
    GPIO_OUTPUT_SET(GPIO_ID_PIN(12), 1);
    at_response_ok();
}

extern void at_exeCmdCiupdate(uint8_t id);
at_funcationType at_custom_cmd[] = {
    {"+LEDON", 6, NULL, NULL, NULL, at_exeCmdLedOn},
    {"+LEDOFF", 7, NULL, NULL, NULL, at_exeCmdLedOff}
};



////
//void ICACHE_FLASH_ATTR
//user_link_led_timer_cb(void) {
//    static uint8 counter = 0;
//    counter++;
//    
//    uint8 connectionStatus = wifi_station_get_connect_status();
//    
//    switch (connectionStatus) {
//        case STATION_IDLE:
//            GPIO_OUTPUT_SET(GPIO_ID_PIN(12), 1);
//            break;
//        case STATION_CONNECTING:
//            link_led_level = (~link_led_level) & 0x01;
//            GPIO_OUTPUT_SET(GPIO_ID_PIN(12), link_led_level);
//            break;
//        case STATION_CONNECT_FAIL:
//            if (counter % 4 == 0) {
//                link_led_level = (~link_led_level) & 0x01;
//                GPIO_OUTPUT_SET(GPIO_ID_PIN(12), link_led_level);
//            }
//            break;
//        case STATION_GOT_IP:
//            GPIO_OUTPUT_SET(GPIO_ID_PIN(12), 0);
//            break;
//            
//        default:
//            break;
//    }
//
//    at_port_print("\r\n : ) \r\n");
//    
//}
//
//void ICACHE_FLASH_ATTR
//user_link_led_timer_init(void)
//{
//    link_start_time = system_get_time();
//    
//    os_timer_disarm(&link_led_timer);
//    os_timer_setfn(&link_led_timer, (os_timer_func_t *)user_link_led_timer_cb, NULL);
//    os_timer_arm(&link_led_timer, 250, 1);
//    link_led_level = 0;
//    PIN_FUNC_SELECT(PERIPHS_IO_MUX_MTDI_U, FUNC_GPIO12);
//    GPIO_OUTPUT_SET(GPIO_ID_PIN(12), link_led_level);
//}
//
//void ICACHE_FLASH_ATTR
//user_link_led_timer_done(void)
//{
//    os_timer_disarm(&link_led_timer);
//    GPIO_OUTPUT_SET(GPIO_ID_PIN(0), 0);
//}


void user_rf_pre_init(void)
{
}

void user_init(void)
{
    char ainfo[64] = {0};

    at_customLinkMax = 5;
    at_init();
    os_sprintf(ainfo,"SeeedStudio\ncompile time:%s %s",__DATE__,__TIME__);
    at_set_custom_info (ainfo);

    at_port_print("\r\nready\r\n");
    
    PIN_FUNC_SELECT(PERIPHS_IO_MUX_MTDI_U, FUNC_GPIO12);

    at_cmd_array_regist(&at_custom_cmd[0], sizeof(at_custom_cmd)/sizeof(at_custom_cmd[0]));

    system_phy_set_max_tpw(30);

    //user_link_led_timer_init();

#define HUMITURE_WIFI_LED_IO_MUX PERIPHS_IO_MUX_GPIO0_U
#define HUMITURE_WIFI_LED_IO_NUM 0
#define HUMITURE_WIFI_LED_IO_FUNC FUNC_GPIO0
    wifi_status_led_install(HUMITURE_WIFI_LED_IO_NUM,
                            HUMITURE_WIFI_LED_IO_MUX, HUMITURE_WIFI_LED_IO_FUNC);
}
